function Figure6S1D()
% This script plots the data from Figure 6 - figure supplement 1D.

load('recovery_data.mat');
% X1: fraction recovery for pre-F particles
% X2: fraction recovery for post-F particles
% X3: fraction recovery for osmotically-swollen particles
% X4: fraction recovery for osmotically-swollen particles +0.5% PFA

X1 = 100*X1;
X2 = 100*X2;
X3 = 100*X3;
X4 = 100*X4;

% Randomize the point placement so that they di not all overlap:
U1 = randn(size(X1))/3+1;       u1 = [min(U1) max(U1)];
U2 = randn(size(X2))/3+3;       u2 = [min(U2) max(U2)];
U3 = randn(size(X3))/3+5;       u3 = [min(U3) max(U3)];
U4 = randn(size(X4))/3+7;       u4 = [min(U4) max(U4)];

plot(U1,X1,'.',U2,X2,'.',U3,X3,'.',U4,X4,'.','MarkerSize',24);
hold on;
plot(u1,median(X1)*[1 1],'k',u2,median(X2)*[1 1],'k',u3,median(X3)*[1 1],'k',u4,median(X4)*[1 1],'k')

xticks([1 3 5 7]);
xticklabels({'Pre-F','Post-F','Swollen','Swollen + PFA'});
ylabel('Percent recovery')

[h1,p] = kstest2(X1,X2);
disp(['p-value for pre-F / post-F comparison: ',num2str(p)]);
[h,p] = kstest2(X2,X3);
disp(['p-value for post-F / osmotically-swollen comparison: ',num2str(p)]);
[h,p] = kstest2(X3,X4);
disp(['p-value for osmotically-swollen +/-PFA comparison: ',num2str(p)]);